<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ai_messages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('business_id');
            $table->unsignedBigInteger('supplier_id')->nullable();
            $table->string('scope', 32)->nullable();
            $table->string('intent', 32)->nullable();
            $table->string('time_label', 32)->nullable();
            $table->string('normalized_query', 255)->nullable();
            $table->text('question');
            $table->text('answer')->nullable();
            $table->boolean('ok')->default(true);
            $table->tinyInteger('rating')->nullable(); // 1 thumbs up, -1 thumbs down
            $table->timestamps();

            $table->index(['business_id', 'supplier_id', 'scope', 'intent', 'time_label'], 'ai_msg_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ai_messages');
    }
};
